//=============================================================================
// Plugin for RPG Maker MZ
// Absorption.js
//=============================================================================

/*:
 * @target MZ
 * @plugindesc 与えたダメージを吸収し、
 * 生存者にそのダメージを分配して回復するスキルを作成できるようにします。
 * @author レイジ
 *
 * @help このプラグインには、プラグインコマンドはありません。
 * このプラグインは、RPGツクールMZに対応しています。
 * このプラグインは、与えたダメージを吸収し、
 * 生存しているパーティメンバーに分配して回復するスキルを
 * 作成可能にします。
 *
 * ■概要
 * スキルのメモ欄に、以下のように書くと、そのスキルは、全体吸収スキルになります。
 * <Absorption>
 *
 * ■ライセンス表記
 * このプラグインは MIT ライセンスで配布されます。
 * ご自由にお使いください。
 * http://opensource.org/licenses/mit-license.php
 */

(() => {
  const hasAbsorptionMeta = skill => !!(skill && skill.meta.Absorption);

  const _SkillExecute = Game_Action.prototype.executeHpDamage;
  Game_Action.prototype.executeHpDamage = function (target, value) {
    $gameTemp.currentItem = this.item();
    if (this.subject().isActor() && target.isEnemy() && this.item() && 
    hasAbsorptionMeta($gameTemp.currentItem)) {
      for (const actor of $gameParty.aliveMembers()) {
        actor.gainHp(Math.floor(value / $gameParty.aliveMembers().length));
      }
    }
    _SkillExecute.call(this, target, value);
  };

  const _Window_BattleLog_popupDamage =
   Window_BattleLog.prototype.popupDamage;
  Window_BattleLog.prototype.popupDamage = function(target) {
    if (target.isActor() && hasAbsorptionMeta($gameTemp.currentItem)) {
      $gameTemp.currentItem = false;
      for (const actor of $gameParty.members()) {
        _Window_BattleLog_popupDamage.call(this, actor);
      }
      return;
    }
    _Window_BattleLog_popupDamage.call(this, target);
  };

})();
